import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 10))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
clean_color = 'white'
used_color = 'gray'

# Add dispensers
ax.add_patch(patches.Rectangle((2, 9), 1, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(2.5, 9.5, 'dispenser_1\n(ingredient1)', color='black', ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((8, 9), 1, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(8.5, 9.5, 'dispenser_2\n(ingredient2)', color='black', ha='center', va='center', fontsize=8)

# Add shots
ax.add_patch(patches.Rectangle((2, 6), 1, 1, edgecolor='black', facecolor=clean_color))
ax.text(2.5, 6.5, 'shot_1\n(clean, empty)', color='black', ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((5, 6), 1, 1, edgecolor='black', facecolor=clean_color))
ax.text(5.5, 6.5, 'shot_2\n(clean, empty)', color='black', ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((8, 6), 1, 1, edgecolor='black', facecolor=clean_color))
ax.text(8.5, 6.5, 'shot_3\n(clean, empty)', color='black', ha='center', va='center', fontsize=8)

# Add shaker
ax.add_patch(patches.Circle((5.5, 3.5), 1, edgecolor='black', facecolor=clean_color))
ax.text(5.5, 3.5, 'shaker_1\n(clean, empty,\nl0)', color='black', ha='center', va='center', fontsize=8)

# Add hands
ax.add_patch(patches.Rectangle((1, 1), 1, 0.5, edgecolor='black', facecolor=clean_color))
ax.text(1.5, 1.25, 'left_hand\n(empty)', color='black', ha='center', va='center', fontsize=8)

ax.add_patch(patches.Rectangle((9, 1), 1, 0.5, edgecolor='black', facecolor=clean_color))
ax.text(9.5, 1.25, 'right_hand\n(empty)', color='black', ha='center', va='center', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 12)
ax.set_ylim(0, 12)
ax.axis('off')

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1 (red)'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2 (blue)'),
    patches.Patch(facecolor=clean_color, edgecolor='black', label='clean/empty (white)'),
    patches.Patch(facecolor=used_color, edgecolor='black', label='used (gray)')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_3.png')
plt.show()